#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Scatterform1B - UnfoldMod01.fsh    by   audiopixel
//https://www.shadertoy.com/view/WlXSWn
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Created by Hepp Maccoy 2019, hepp@audiopixel.com
// Built with Haxademic+Scatterform, github.com/cacheflowe/haxademic
// Distance functions by Inigo Quilez, iquilezles.org
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License

float PI = 3.14159265358979323846;
float d1;
float t1;

float soc(vec3 p) {
    vec3 n = normalize(sign(p+1e6));
    return min(min(dot(p.xy, n.xy), dot(p.yz, n.yz)), dot(p.xz, n.xz));
}

float sinc(float x, float k) {
    float a = PI * (float(k)*x-1.0);
    return sin(a)/a;
}

mat2 r2d(float a) {
    float sa=sin(a);
    float ca=cos(a);
    return mat2(ca,sa,-sa,ca);
}

vec2 mo(inout vec2 p, vec2 d) {
    vec2 q = p;
    q.x = abs(q.x) - d.x;
    q.y = abs(q.y) - d.y;
    if (q.y > q.x) q = q.yx;
    return q;
}

vec2 amod(vec2 p, float m) {
    float a=mod(atan(p.x,p.y), m)-m*.5;
    return vec2(cos(a), sin(a))*length(p);
}

float map(vec3 p) {
    float d = 1.0;
    float a = abs(p.y);
    p.yz *= r2d(sign(a) * 1.2);
    p.xz *= r2d(sign(a) * 0.0);
    p.xz = mo(p.xz, vec2((-d1 * 35.8) - 1., (d1 * 65.8) - 1.));
    p.zx = mo(p.xz, vec2((d1 * 2.) - 4., 0.0282));
    p.xz = amod(p.xz, (PI * 1.0) / 2.0);
    p.xz = max(abs(p.xz) - 2.2569, -1.29);
    p.x = mod(p.x, 0.3198 + (d1 * .21))-(0.3198 + (d1 * .21) *.5);
    p.y = mod(p.y + -sin(t1 * .023) * 1.2, 6.752) - 5.;
    d = min(d, soc(max(abs(p) - 0.172, 0.0096)));
    return (length(p * 0.0) - 0.0) * 1.0 - (d * -1.0);
}

vec3 calcNormal(in vec3 p, in int type, in float m1, in float m2, in float m3) {
    vec2 e = vec2(m2, m3) * m1;
    return normalize( e.xyy * map(p + e.xyy) + e.yyx * map(p + e.yyx) + e.yxy * map(p + e.yxy) + e.xxx * map(p + e.xxx) );
}

//void mainImage(out vec4 fragColor, in vec2 fragCoord) {
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) {
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    t1 = iTime;
    //t1 = (sin((iTime + 174.) * .1) * 15.) + 21.;
    d1 = sin(t1 * .013);
    vec2 st = (fragCoord.xy / iResolution.xy) * 2.05 - 1.;
    st.x *= iResolution.x / iResolution.y;
    vec3 ro = vec3(st, 3.7287);
    vec3 rd = normalize(vec3(st + vec2(0.), -0.8572));
    vec3 mp;
    mp = ro;
    float md;
    for(int i=0; i<45; i++) {
        md = map(mp);
        mp += (rd * .6 + (-d1 * .1)) * md;
    }
    float b = length(ro - mp);
    float dA = 0.4799 - (b * 0.02) * 0.5232;
    float dB = 0.479 - (b * 0.03) * 0.523;
    dA = sinc(dA, 1.0);
    dB = sinc(dB, 1.0);
    vec3 p = ro + rd * (mp);
    vec3 lt = vec3(0.0, 0.0, 0.0);
    vec3 l;
    vec3 nm = calcNormal(p, 0, 4.5201, 1.0, -1.0);
    if (md < 0.015) {
        float dif = clamp(dot(nm, normalize(lt - p)), 0., 1.);
        dif *= 5.0 / dot(lt - p, lt - p);
        l = vec3(pow(dif, 0.1854));
    }
    vec3 lt2 = vec3(0.0, 0.0, 13.0);
    vec3 nm2 = calcNormal(p, 0, 2.8964, -1.0, -1.339);
    float dif2 = clamp(dot(nm2, normalize(lt2 - p)), 0., 1.);
    dif2 *= 4.0 / dot(lt2 - p, lt2 - p);
    vec3 lb = vec3(pow(dif2, 0.4545));
    float src1 = 1. * 0.0;
    float src2 = nm.x;
    float src3 = l.x;
    float src4 = lb.x * 0.4;
    vec3 c;
    c = mix(vec3(0.0), vec3(0.6117647,0.019607844,0.8627451), src1) + mix(vec3(0.0), vec3(1.0,0.0,0.0), src2);
    c = c + mix(vec3(0.0), vec3(0.31764707,0.5568628,1.0), src3);
    c = c + mix(vec3(0.0), vec3(0.05490196,0.0,1.0), src4);
    fragColor = vec4(c, 1.);
//
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

